/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.gl.arena;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Stream;
import net.caffeinemc.mods.sodium.client.gl.arena.GlBufferSegment;
import net.caffeinemc.mods.sodium.client.gl.arena.PendingBufferCopyCommand;
import net.caffeinemc.mods.sodium.client.gl.arena.PendingUpload;
import net.caffeinemc.mods.sodium.client.gl.arena.staging.StagingBuffer;
import net.caffeinemc.mods.sodium.client.gl.buffer.GlBuffer;
import net.caffeinemc.mods.sodium.client.gl.buffer.GlBufferUsage;
import net.caffeinemc.mods.sodium.client.gl.buffer.GlMutableBuffer;
import net.caffeinemc.mods.sodium.client.gl.device.CommandList;

public class GlBufferArena {
    static final boolean CHECK_ASSERTIONS = false;
    public static final int MIN_SEGMENTS_FOR_AVG = 16;
    public static final float FEW_SEGMENTS_GROWTH_FACTOR = 1.5f;
    public static final float EXPECTED_SIZE_TARGET_FACTOR = 1.5f;
    public static final float MAX_BUFFER_REUSE_SIZE_FACTOR = 1.4f;
    private static final GlBufferUsage BUFFER_USAGE = GlBufferUsage.STATIC_DRAW;
    private final StagingBuffer stagingBuffer;
    private GlMutableBuffer arenaBuffer;
    private GlBufferSegment head;
    private long capacity;
    private long used;
    private int segmentCount;
    private final int stride;
    private static final GlMutableBuffer[] freeBuffers = new GlMutableBuffer[8];
    private static int freeBufferCount = 0;

    public GlBufferArena(CommandList commands, int initialCapacity, int stride, StagingBuffer stagingBuffer) {
        this.capacity = initialCapacity;
        this.stride = stride;
        this.head = new GlBufferSegment(this, 0L, this.capacity);
        this.head.setFree(true);
        this.arenaBuffer = GlBufferArena.getBufferOfSizeAtLeast(commands, this.capacity * (long)stride);
        this.capacity = this.arenaBuffer.getSize() / (long)stride;
        this.stagingBuffer = stagingBuffer;
    }

    private void resize(CommandList commandList, long newCapacity) {
        if (this.used > newCapacity) {
            throw new UnsupportedOperationException("New capacity must be larger than used size");
        }
        this.checkAssertions();
        long tail = newCapacity - this.used;
        ArrayList<GlBufferSegment> usedSegments = this.getUsedSegments();
        List<PendingBufferCopyCommand> pendingCopies = this.buildTransferList(usedSegments, tail);
        this.transferSegments(commandList, pendingCopies, newCapacity);
        this.head = new GlBufferSegment(this, 0L, tail);
        this.head.setFree(true);
        if (usedSegments.isEmpty()) {
            this.head.setNext(null);
        } else {
            this.head.setNext((GlBufferSegment)usedSegments.getFirst());
            this.head.getNext().setPrev(this.head);
        }
        this.checkAssertions();
    }

    private List<PendingBufferCopyCommand> buildTransferList(List<GlBufferSegment> usedSegments, long base) {
        ArrayList<PendingBufferCopyCommand> pendingCopies = new ArrayList<PendingBufferCopyCommand>();
        PendingBufferCopyCommand currentCopyCommand = null;
        long writeOffset = base;
        for (int i = 0; i < usedSegments.size(); ++i) {
            GlBufferSegment s = usedSegments.get(i);
            if (currentCopyCommand == null || currentCopyCommand.getReadOffset() + currentCopyCommand.getLength() != s.getOffset()) {
                if (currentCopyCommand != null) {
                    pendingCopies.add(currentCopyCommand);
                }
                currentCopyCommand = new PendingBufferCopyCommand(s.getOffset(), writeOffset, s.getLength());
            } else {
                currentCopyCommand.setLength(currentCopyCommand.getLength() + s.getLength());
            }
            s.setOffset(writeOffset);
            if (i + 1 < usedSegments.size()) {
                s.setNext(usedSegments.get(i + 1));
            } else {
                s.setNext(null);
            }
            if (i - 1 < 0) {
                s.setPrev(null);
            } else {
                s.setPrev(usedSegments.get(i - 1));
            }
            writeOffset += s.getLength();
        }
        if (currentCopyCommand != null) {
            pendingCopies.add(currentCopyCommand);
        }
        return pendingCopies;
    }

    private static GlMutableBuffer getBufferOfSizeAtLeast(CommandList commandList, long size) {
        GlMutableBuffer buffer = null;
        if (freeBufferCount > 0) {
            long maxAcceptableSize = (long)((float)size * 1.4f);
            int candidateIndex = -1;
            for (int i = 0; i < freeBuffers.length; ++i) {
                long testSize;
                GlMutableBuffer freeBuffer = freeBuffers[i];
                if (freeBuffer == null || (testSize = freeBuffer.getSize()) < size || testSize > maxAcceptableSize || buffer != null && testSize >= buffer.getSize()) continue;
                candidateIndex = i;
                buffer = freeBuffer;
            }
            if (buffer != null) {
                GlBufferArena.freeBuffers[candidateIndex] = null;
                --freeBufferCount;
            }
        }
        if (buffer == null) {
            buffer = commandList.createMutableBuffer();
            commandList.allocateStorage(buffer, size, BUFFER_USAGE);
        }
        return buffer;
    }

    private static void releaseBufferForReuse(CommandList commandList, GlMutableBuffer buffer) {
        if (freeBufferCount < freeBuffers.length) {
            for (int i = 0; i < freeBuffers.length; ++i) {
                if (freeBuffers[i] != null) continue;
                GlBufferArena.freeBuffers[i] = buffer;
                ++freeBufferCount;
                return;
            }
        }
        int evictIndex = (int)(Math.random() * (double)freeBuffers.length);
        commandList.deleteBuffer(freeBuffers[evictIndex]);
        GlBufferArena.freeBuffers[evictIndex] = buffer;
    }

    private void transferSegments(CommandList commandList, Collection<PendingBufferCopyCommand> list, long capacity) {
        long bufferSize = capacity * (long)this.stride;
        if (bufferSize >= 0x100000000L) {
            throw new IllegalArgumentException("Maximum arena buffer size is 4 GiB");
        }
        GlMutableBuffer srcBufferObj = this.arenaBuffer;
        GlMutableBuffer dstBufferObj = GlBufferArena.getBufferOfSizeAtLeast(commandList, bufferSize);
        for (PendingBufferCopyCommand cmd : list) {
            commandList.copyBufferSubData(srcBufferObj, dstBufferObj, cmd.getReadOffset() * (long)this.stride, cmd.getWriteOffset() * (long)this.stride, cmd.getLength() * (long)this.stride);
        }
        GlBufferArena.releaseBufferForReuse(commandList, srcBufferObj);
        this.arenaBuffer = dstBufferObj;
        this.capacity = this.arenaBuffer.getSize() / (long)this.stride;
    }

    private ArrayList<GlBufferSegment> getUsedSegments() {
        ArrayList<GlBufferSegment> used = new ArrayList<GlBufferSegment>();
        GlBufferSegment seg = this.head;
        while (seg != null) {
            GlBufferSegment next = seg.getNext();
            if (!seg.isFree()) {
                used.add(seg);
            }
            seg = next;
        }
        return used;
    }

    public long getDeviceUsedMemory() {
        return this.used * (long)this.stride;
    }

    public long getDeviceAllocatedMemory() {
        return this.capacity * (long)this.stride;
    }

    private void updateUsed(long deltaUsed) {
        this.used += deltaUsed;
        this.segmentCount += Long.signum(deltaUsed);
    }

    private GlBufferSegment alloc(int size) {
        GlBufferSegment result;
        GlBufferSegment a = this.findFree(size);
        if (a == null) {
            return null;
        }
        if (a.getLength() == (long)size) {
            a.setFree(false);
            result = a;
        } else {
            GlBufferSegment b = new GlBufferSegment(this, a.getEnd() - (long)size, size);
            b.setNext(a.getNext());
            b.setPrev(a);
            if (b.getNext() != null) {
                b.getNext().setPrev(b);
            }
            a.setLength(a.getLength() - (long)size);
            a.setNext(b);
            result = b;
        }
        this.updateUsed(result.getLength());
        this.checkAssertions();
        return result;
    }

    private GlBufferSegment findFree(int size) {
        GlBufferSegment best = null;
        for (GlBufferSegment entry = this.head; entry != null; entry = entry.getNext()) {
            if (!entry.isFree()) continue;
            if (entry.getLength() == (long)size) {
                return entry;
            }
            if (entry.getLength() < (long)size || best != null && best.getLength() <= entry.getLength()) continue;
            best = entry;
        }
        return best;
    }

    public void free(GlBufferSegment entry) {
        GlBufferSegment prev;
        if (entry.isFree()) {
            throw new IllegalStateException("Already freed");
        }
        entry.setFree(true);
        this.updateUsed(-entry.getLength());
        GlBufferSegment next = entry.getNext();
        if (next != null && next.isFree()) {
            entry.mergeInto(next);
        }
        if ((prev = entry.getPrev()) != null && prev.isFree()) {
            prev.mergeInto(entry);
        }
        this.checkAssertions();
    }

    public void delete(CommandList commands) {
        commands.deleteBuffer(this.arenaBuffer);
    }

    public boolean isEmpty() {
        return this.used <= 0L;
    }

    public GlBuffer getBufferObject() {
        return this.arenaBuffer;
    }

    public boolean upload(CommandList commandList, Stream<PendingUpload> stream, float regionFillFractionInv) {
        GlMutableBuffer buffer = this.arenaBuffer;
        long totalUploadSize = 0L;
        LinkedList<PendingUpload> queue = new LinkedList<PendingUpload>();
        for (PendingUpload upload : stream::iterator) {
            totalUploadSize += (long)upload.getDataBuffer().getLength();
            queue.add(upload);
        }
        if (totalUploadSize < (this.capacity - this.used) * (long)this.stride) {
            this.tryUploads(commandList, queue);
        }
        if (!queue.isEmpty()) {
            this.resize(commandList, this.estimateNewCapacity(regionFillFractionInv, queue));
            this.tryUploads(commandList, queue);
            if (!queue.isEmpty()) {
                throw new RuntimeException("Failed to upload all buffers");
            }
        }
        return this.arenaBuffer != buffer;
    }

    private long estimateNewCapacity(float regionFillFractionInv, List<PendingUpload> queue) {
        long newCapacity;
        long requiredTotalSize = this.getRequiredTotalSize(queue);
        int newSegmentCount = this.segmentCount + queue.size();
        if (newSegmentCount >= 16) {
            long averageNewSegmentSize = requiredTotalSize / (long)newSegmentCount + 1L;
            float expectedSegmentCount = (float)newSegmentCount * regionFillFractionInv;
            newCapacity = (long)((float)averageNewSegmentSize * expectedSegmentCount * 1.5f);
        } else {
            newCapacity = (long)((float)requiredTotalSize * 1.5f);
        }
        return newCapacity;
    }

    private long getRequiredTotalSize(List<PendingUpload> queue) {
        long remainingUploadSize = 0L;
        for (PendingUpload upload : queue) {
            remainingUploadSize += (long)upload.getDataBuffer().getLength();
        }
        long remainingElements = remainingUploadSize / (long)this.stride;
        return remainingElements + this.used;
    }

    private void tryUploads(CommandList commandList, List<PendingUpload> queue) {
        queue.removeIf(upload -> this.tryUpload(commandList, (PendingUpload)upload));
        this.stagingBuffer.flush(commandList);
    }

    private boolean tryUpload(CommandList commandList, PendingUpload upload) {
        ByteBuffer data = upload.getDataBuffer().getDirectBuffer();
        int elementCount = data.remaining() / this.stride;
        GlBufferSegment dst = this.alloc(elementCount);
        if (dst == null) {
            return false;
        }
        this.stagingBuffer.enqueueCopy(commandList, data, this.arenaBuffer, dst.getOffset() * (long)this.stride);
        upload.setResult(dst);
        return true;
    }

    private void checkAssertions() {
    }

    private void checkAssertions0() {
        GlBufferSegment seg = this.head;
        long used = 0L;
        while (seg != null) {
            GlBufferSegment prev;
            GlBufferSegment next;
            if (seg.getOffset() < 0L) {
                throw new IllegalStateException("segment.start < 0: out of bounds");
            }
            if (seg.getEnd() > this.capacity) {
                throw new IllegalStateException("segment.end > arena.capacity: out of bounds");
            }
            if (!seg.isFree()) {
                used += seg.getLength();
            }
            if ((next = seg.getNext()) != null) {
                if (next.getOffset() < seg.getEnd()) {
                    throw new IllegalStateException("segment.next.start < segment.end: overlapping segments (corrupted)");
                }
                if (next.getOffset() > seg.getEnd()) {
                    throw new IllegalStateException("segment.next.start > segment.end: not truly connected (sparsity error)");
                }
                if (next.isFree() && next.getNext() != null && next.getNext().isFree()) {
                    throw new IllegalStateException("segment.free && segment.next.free: not merged consecutive segments");
                }
            }
            if ((prev = seg.getPrev()) != null) {
                if (prev.getEnd() > seg.getOffset()) {
                    throw new IllegalStateException("segment.prev.end > segment.start: overlapping segments (corrupted)");
                }
                if (prev.getEnd() < seg.getOffset()) {
                    throw new IllegalStateException("segment.prev.end < segment.start: not truly connected (sparsity error)");
                }
                if (prev.isFree() && prev.getPrev() != null && prev.getPrev().isFree()) {
                    throw new IllegalStateException("segment.free && segment.prev.free: not merged consecutive segments");
                }
            }
            seg = next;
        }
        if (this.used < 0L) {
            throw new IllegalStateException("arena.used < 0: failure to track");
        }
        if (this.used > this.capacity) {
            throw new IllegalStateException("arena.used > arena.capacity: failure to track");
        }
        if (this.used != used) {
            throw new IllegalStateException("arena.used is invalid");
        }
    }
}

