/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.gui.prompt;

import java.util.List;
import java.util.Objects;
import net.caffeinemc.mods.sodium.client.gui.ButtonTheme;
import net.caffeinemc.mods.sodium.client.gui.prompt.ScreenPromptable;
import net.caffeinemc.mods.sodium.client.gui.widgets.AbstractWidget;
import net.caffeinemc.mods.sodium.client.gui.widgets.FlatButtonWidget;
import net.caffeinemc.mods.sodium.client.util.Dim2i;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import org.jspecify.annotations.NonNull;

public class ScreenPrompt
implements class_364,
class_4068 {
    private static final ButtonTheme PROMPT_THEME = new ButtonTheme(-1, -1, -1, -13027015, -13948117, -13948117);
    private final ScreenPromptable parent;
    private final List<class_5348> text;
    private final Action action;
    private FlatButtonWidget closeButton;
    private FlatButtonWidget actionButton;
    private final int width;
    private final int height;

    public ScreenPrompt(ScreenPromptable parent, List<class_5348> text, int width, int height, Action action) {
        this.parent = parent;
        this.text = text;
        this.width = width;
        this.height = height;
        this.action = action;
    }

    public void init() {
        Dim2i parentDimensions = this.parent.getDimensions();
        int boxX = parentDimensions.width() / 2 - this.width / 2;
        int boxY = parentDimensions.height() / 2 - this.height / 2;
        this.closeButton = new FlatButtonWidget(new Dim2i(boxX + this.width - 84, boxY + this.height - 24, 80, 20), (class_2561)class_2561.method_43470((String)"Close"), this::close, true, false, PROMPT_THEME);
        this.actionButton = new FlatButtonWidget(new Dim2i(boxX + this.width - 198, boxY + this.height - 24, 110, 20), this.action.label, this::runAction, true, false, PROMPT_THEME);
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
        Dim2i parentDimensions = this.parent.getDimensions();
        graphics.method_25294(0, 0, parentDimensions.width(), parentDimensions.height(), 0x70090909);
        int boxX = parentDimensions.width() / 2 - this.width / 2;
        int boxY = parentDimensions.height() / 2 - this.height / 2;
        graphics.method_25294(boxX, boxY, boxX + this.width, boxY + this.height, -15263977);
        graphics.method_73198(boxX, boxY, this.width, this.height, -15592942);
        int padding = 5;
        int textX = boxX + padding;
        int textY = boxY + padding;
        int textMaxWidth = this.width - padding * 2;
        class_327 font = class_310.method_1551().field_1772;
        for (class_5348 paragraph : this.text) {
            List formatted = font.method_1728(paragraph, textMaxWidth);
            for (class_5481 line : formatted) {
                graphics.method_51430(font, line, textX, textY, -1, true);
                Objects.requireNonNull(font);
                textY += 9 + 2;
            }
            textY += 8;
        }
        for (AbstractWidget button : this.getWidgets()) {
            button.method_25394(graphics, mouseX, mouseY, delta);
        }
    }

    public @NonNull List<AbstractWidget> getWidgets() {
        return List.of(this.actionButton, this.closeButton);
    }

    public void method_25365(boolean focused) {
        if (focused) {
            this.parent.setPrompt(this);
        } else {
            this.parent.setPrompt(null);
        }
    }

    public boolean method_25402(class_11909 event, boolean doubleClick) {
        for (AbstractWidget widget : this.getWidgets()) {
            if (!widget.method_25402(event, doubleClick)) continue;
            return true;
        }
        return false;
    }

    public boolean method_25404(class_11908 event) {
        if (event.method_74231()) {
            this.close();
            return true;
        }
        return super.method_25404(event);
    }

    public boolean method_25370() {
        return this.parent.getPrompt() == this;
    }

    private void close() {
        this.parent.setPrompt(null);
    }

    private void runAction() {
        this.action.runnable.run();
        this.close();
    }

    public record Action(class_2561 label, Runnable runnable) {
    }
}

