/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.data;

import it.unimi.dsi.fastutil.objects.Object2ReferenceMap;
import java.nio.IntBuffer;
import java.util.function.IntConsumer;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.data.CombinedCameraPos;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.data.DynamicData;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.data.DynamicSorter;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.data.TopoGraphSorting;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.data.TranslucentData;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.quad.TQuad;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.trigger.GeometryPlanes;
import net.caffeinemc.mods.sodium.client.util.sorting.RadixSort;
import net.minecraft.class_4076;
import org.joml.Vector3dc;
import org.joml.Vector3fc;

public class DynamicTopoData
extends DynamicData {
    private static final int MAX_TOPO_SORT_QUADS = 1000;
    private static final int MAX_TOPO_SORT_TIME_NS = 1000000;
    private static final int MAX_FAILING_TOPO_SORT_TIME_NS = 750000;
    private static final int MAX_TOPO_SORT_PATIENT_TIME_NS = 250000;
    private static final int PATIENT_TOPO_ATTEMPTS = 5;
    private static final int REGULAR_TOPO_ATTEMPTS = 2;
    private boolean GFNITrigger = true;
    private boolean directTrigger = false;
    private int consecutiveTopoSortFailures = 0;
    private double directTriggerKey = -1.0;
    private boolean pendingTriggerIsDirect;
    private final TQuad[] quads;
    private final Object2ReferenceMap<Vector3fc, float[]> distancesByNormal;

    private DynamicTopoData(class_4076 sectionPos, TQuad[] quads, GeometryPlanes geometryPlanes, Vector3dc initialCameraPos, Object2ReferenceMap<Vector3fc, float[]> distancesByNormal) {
        super(sectionPos, quads.length, geometryPlanes, initialCameraPos);
        this.quads = quads;
        this.distancesByNormal = distancesByNormal;
        if (this.getInputQuadCount() > 1000) {
            this.directTrigger = true;
            this.GFNITrigger = false;
        }
    }

    @Override
    public DynamicSorter getSorter() {
        return new DynamicTopoSorter(this.getInputQuadCount(), this, this.pendingTriggerIsDirect, this.consecutiveTopoSortFailures, this.GFNITrigger, this.directTrigger);
    }

    public boolean GFNITriggerEnabled() {
        return this.GFNITrigger;
    }

    public boolean directTriggerEnabled() {
        return this.directTrigger;
    }

    public double getDirectTriggerKey() {
        return this.directTriggerKey;
    }

    public void setDirectTriggerKey(double key) {
        this.directTriggerKey = key;
    }

    public boolean isMatchingSorter(DynamicTopoSorter sorter) {
        return sorter.parent == this;
    }

    public boolean checkAndApplyGFNITriggerOff(DynamicTopoSorter sorter) {
        if (this.GFNITrigger && !sorter.GFNITrigger) {
            this.GFNITrigger = false;
            return true;
        }
        return false;
    }

    public boolean checkAndApplyDirectTriggerOff(DynamicTopoSorter sorter) {
        if (this.directTrigger && !sorter.directTrigger) {
            this.directTrigger = false;
            return true;
        }
        return false;
    }

    public boolean checkAndApplyDirectTriggerOn(DynamicTopoSorter sorter) {
        if (!this.directTrigger && sorter.directTrigger) {
            this.directTrigger = true;
            return true;
        }
        return false;
    }

    public void applyTopoSortFailureCounterChange(DynamicTopoSorter sorter) {
        if (sorter.hasSortFailureReset()) {
            this.consecutiveTopoSortFailures = 0;
        } else if (sorter.hasSortFailureIncrement()) {
            ++this.consecutiveTopoSortFailures;
        }
    }

    private void copyStateFrom(DynamicTopoSorter sorter) {
        this.GFNITrigger = sorter.GFNITrigger;
        this.directTrigger = sorter.directTrigger;
        this.consecutiveTopoSortFailures = sorter.consecutiveTopoSortFailuresNew;
    }

    @Override
    public void prepareTrigger(boolean isDirectTrigger) {
        this.pendingTriggerIsDirect = isDirectTrigger;
    }

    static void distanceSortDirect(IntBuffer indexBuffer, TQuad[] quads, Vector3fc cameraPos) {
        if (quads.length <= 1) {
            TranslucentData.writeQuadVertexIndexes(indexBuffer, 0);
        } else {
            int idx;
            int[] keys = new int[quads.length];
            int[] perm = new int[quads.length];
            for (idx = 0; idx < quads.length; ++idx) {
                Vector3fc centroid = quads[idx].getCenter();
                keys[idx] = ~Float.floatToRawIntBits(centroid.distanceSquared(cameraPos));
                perm[idx] = idx;
            }
            RadixSort.sortIndirect(perm, keys, false);
            for (idx = 0; idx < quads.length; ++idx) {
                TranslucentData.writeQuadVertexIndexes(indexBuffer, perm[idx]);
            }
        }
    }

    public static DynamicTopoData fromMesh(CombinedCameraPos cameraPos, TQuad[] quads, class_4076 sectionPos, GeometryPlanes geometryPlanes) {
        Object2ReferenceMap<Vector3fc, float[]> distancesByNormal = geometryPlanes.prepareAndGetDistances();
        return new DynamicTopoData(sectionPos, quads, geometryPlanes, cameraPos.getAbsoluteCameraPos(), distancesByNormal);
    }

    public class DynamicTopoSorter
    extends DynamicSorter
    implements IntConsumer {
        private final DynamicTopoData parent;
        private final boolean isDirectTrigger;
        private final int consecutiveTopoSortFailures;
        private boolean directTrigger;
        private boolean GFNITrigger;
        private int consecutiveTopoSortFailuresNew;
        private IntBuffer intBuffer;

        private DynamicTopoSorter(int quadCount, DynamicTopoData parent, boolean isDirectTrigger, int consecutiveTopoSortFailures, boolean GFNITrigger, boolean directTrigger) {
            super(quadCount);
            this.parent = parent;
            this.isDirectTrigger = isDirectTrigger;
            this.consecutiveTopoSortFailures = consecutiveTopoSortFailures;
            this.consecutiveTopoSortFailuresNew = consecutiveTopoSortFailures;
            this.GFNITrigger = GFNITrigger;
            this.directTrigger = directTrigger;
        }

        private static int getAttemptsForTime(long ns) {
            return ns <= 250000L ? 5 : 2;
        }

        private boolean hasSortFailureReset() {
            return this.consecutiveTopoSortFailuresNew < this.consecutiveTopoSortFailures;
        }

        private boolean hasSortFailureIncrement() {
            return this.consecutiveTopoSortFailuresNew > this.consecutiveTopoSortFailures;
        }

        @Override
        public void accept(int value) {
            TranslucentData.writeQuadVertexIndexes(this.intBuffer, value);
        }

        @Override
        void writeSort(CombinedCameraPos cameraPos, boolean initial) {
            IntBuffer indexBuffer = this.getIntBuffer();
            if (this.GFNITrigger && !this.isDirectTrigger) {
                long sortTime;
                this.intBuffer = indexBuffer;
                long sortStart = initial ? 0L : System.nanoTime();
                boolean result = TopoGraphSorting.topoGraphSort(this, DynamicTopoData.this.quads, DynamicTopoData.this.distancesByNormal, cameraPos.getRelativeCameraPos(), false);
                this.intBuffer = null;
                long l = sortTime = initial ? 0L : System.nanoTime() - sortStart;
                if (!initial && sortTime > (long)(this.consecutiveTopoSortFailuresNew > 0 ? 750000 : 1000000)) {
                    this.directTrigger = true;
                    this.GFNITrigger = false;
                } else if (result) {
                    this.directTrigger = false;
                    this.consecutiveTopoSortFailuresNew = 0;
                } else {
                    ++this.consecutiveTopoSortFailuresNew;
                    this.directTrigger = true;
                    if (this.consecutiveTopoSortFailuresNew >= DynamicTopoSorter.getAttemptsForTime(sortTime)) {
                        this.GFNITrigger = false;
                    }
                }
            }
            if (this.directTrigger) {
                indexBuffer.rewind();
                DynamicTopoData.distanceSortDirect(indexBuffer, DynamicTopoData.this.quads, cameraPos.getRelativeCameraPos());
            }
            if (initial) {
                DynamicTopoData.this.copyStateFrom(this);
            }
        }
    }
}

