/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.lithium.common.tracking.block;

import it.unimi.dsi.fastutil.longs.Long2ReferenceOpenHashMap;
import java.util.ArrayList;
import net.caffeinemc.mods.lithium.common.block.BlockListeningSection;
import net.caffeinemc.mods.lithium.common.tracking.block.BlockChangeTracker;
import net.caffeinemc.mods.lithium.common.util.Pos;
import net.caffeinemc.mods.lithium.common.world.LithiumData;
import net.caffeinemc.mods.lithium.common.world.chunk.ChunkStatusTracker;
import net.minecraft.class_1937;
import net.minecraft.class_2680;
import net.minecraft.class_2826;
import net.minecraft.class_4076;
import net.minecraft.class_5539;

public final class ChunkSectionChangeCallback {
    private final long sectionPos;
    private ArrayList<BlockChangeTracker> trackers;

    public static void init() {
        if (BlockListeningSection.class.isAssignableFrom(class_2826.class)) {
            ChunkStatusTracker.registerUnloadCallback((serverWorld, chunkPos) -> {
                Long2ReferenceOpenHashMap<ChunkSectionChangeCallback> changeCallbacks = ((LithiumData)serverWorld).lithium$getData().chunkSectionChangeCallbacks();
                int x = chunkPos.field_9181;
                int z = chunkPos.field_9180;
                for (int y = Pos.SectionYCoord.getMinYSection((class_5539)serverWorld); y <= Pos.SectionYCoord.getMaxYSectionInclusive((class_5539)serverWorld); ++y) {
                    class_4076 chunkSectionPos = class_4076.method_18676((int)x, (int)y, (int)z);
                    ChunkSectionChangeCallback chunkSectionChangeCallback = (ChunkSectionChangeCallback)changeCallbacks.remove(chunkSectionPos.method_18694());
                    if (chunkSectionChangeCallback == null) continue;
                    chunkSectionChangeCallback.onChunkSectionInvalidated(chunkSectionPos);
                }
            });
        }
    }

    public ChunkSectionChangeCallback(long sectionPos) {
        this.sectionPos = sectionPos;
    }

    public static ChunkSectionChangeCallback create(long sectionPos, class_1937 world) {
        ChunkSectionChangeCallback chunkSectionChangeCallback = new ChunkSectionChangeCallback(sectionPos);
        Long2ReferenceOpenHashMap<ChunkSectionChangeCallback> changeCallbacks = ((LithiumData)world).lithium$getData().chunkSectionChangeCallbacks();
        ChunkSectionChangeCallback previous = (ChunkSectionChangeCallback)changeCallbacks.put(sectionPos, (Object)chunkSectionChangeCallback);
        if (previous != null) {
            previous.onChunkSectionInvalidated(class_4076.method_18677((long)sectionPos));
        }
        return chunkSectionChangeCallback;
    }

    public void onBlockChange(BlockListeningSection section, int localX, int localY, int localZ, class_2680 oldState, class_2680 newState) {
        ArrayList<BlockChangeTracker> blockChangeTrackers = this.trackers;
        this.trackers = null;
        if (blockChangeTrackers != null) {
            for (int i = blockChangeTrackers.size() - 1; i >= 0; --i) {
                BlockChangeTracker tracker = blockChangeTrackers.get(i);
                if (tracker.setChanged(section, localX, localY, localZ, oldState, newState)) continue;
                BlockChangeTracker swap = blockChangeTrackers.removeLast();
                if (i == blockChangeTrackers.size()) continue;
                blockChangeTrackers.set(i, swap);
            }
            if (this.trackers != null) {
                blockChangeTrackers.addAll(this.trackers);
            }
            if (!blockChangeTrackers.isEmpty()) {
                this.trackers = blockChangeTrackers;
            }
        }
    }

    public void addTracker(BlockChangeTracker tracker) {
        ArrayList<BlockChangeTracker> blockChangeTrackers = this.trackers;
        if (blockChangeTrackers == null) {
            this.trackers = blockChangeTrackers = new ArrayList();
        }
        blockChangeTrackers.add(tracker);
    }

    public void removeTracker(BlockChangeTracker tracker) {
        ArrayList<BlockChangeTracker> blockChangeTrackers = this.trackers;
        if (blockChangeTrackers != null) {
            blockChangeTrackers.remove(tracker);
        }
    }

    public void onChunkSectionInvalidated(class_4076 sectionPos) {
        ArrayList<BlockChangeTracker> blockChangeTrackers = this.trackers;
        this.trackers = null;
        if (blockChangeTrackers != null) {
            for (int i = 0; i < blockChangeTrackers.size(); ++i) {
                blockChangeTrackers.get(i).onChunkSectionInvalidated(sectionPos);
            }
        }
    }

    public long getSectionPos() {
        return this.sectionPos;
    }

    public int getX(int localX) {
        return class_4076.method_18688((int)class_4076.method_18686((long)this.sectionPos)) + localX;
    }

    public int getY(int localY) {
        return class_4076.method_18688((int)class_4076.method_18689((long)this.sectionPos)) + localY;
    }

    public int getZ(int localZ) {
        return class_4076.method_18688((int)class_4076.method_18690((long)this.sectionPos)) + localZ;
    }
}

