/*
 * Decompiled with CFR 0.152.
 */
package net.legacy.item_tooltips.config;

import java.nio.file.Path;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.annotation.ConfigEntry;
import me.shedaniel.autoconfig.serializer.JanksonConfigSerializer;
import net.legacy.item_tooltips.util.ScreenUtil;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

@Config(name="item_tooltips")
public class ITConfig
implements ConfigData {
    public static ITConfig get;
    @ConfigEntry.Gui.CollapsibleObject
    public DescriptionConfig descriptions = new DescriptionConfig();
    @ConfigEntry.Gui.CollapsibleObject
    public TooltipConfig tooltips = new TooltipConfig();
    @ConfigEntry.Gui.CollapsibleObject
    public EnchantmentConfig enchantments = new EnchantmentConfig();

    @Contract(pure=true)
    @NotNull
    public static Path configPath(boolean json5) {
        return Path.of("./config/item_tooltips." + (json5 ? "json5" : "json"), new String[0]);
    }

    public static void init() {
        AutoConfig.register(ITConfig.class, JanksonConfigSerializer::new);
        get = (ITConfig)AutoConfig.getConfigHolder(ITConfig.class).getConfig();
    }

    public static class DescriptionConfig {
        @ConfigEntry.Category(value="config")
        @ConfigEntry.Gui.Tooltip
        public boolean add_descriptions = true;
        @ConfigEntry.Category(value="config")
        @ConfigEntry.Gui.Tooltip
        public boolean require_key_hold = true;
        @ConfigEntry.Category(value="config")
        @ConfigEntry.Gui.Tooltip
        public boolean key_hold_notice = true;
        @ConfigEntry.Category(value="config")
        @ConfigEntry.Gui.Tooltip
        @ConfigEntry.ColorPicker
        public int color = 0x555555;
        @ConfigEntry.Category(value="config")
        @ConfigEntry.Gui.Tooltip
        public String prefix = "";
        @ConfigEntry.Category(value="config")
        @ConfigEntry.Gui.Tooltip
        public boolean prefix_wrapping = false;
        @ConfigEntry.Category(value="config")
        @ConfigEntry.Gui.Tooltip
        @ConfigEntry.ColorPicker
        public int prefix_color = 0xC6C6C6;
    }

    public static class TooltipConfig {
        @ConfigEntry.Category(value="config")
        @ConfigEntry.Gui.Tooltip
        @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON)
        public ScreenUtil.TooltipKey required_key = ScreenUtil.TooltipKey.SHIFT;
        @ConfigEntry.Category(value="config")
        @ConfigEntry.Gui.Tooltip
        public boolean wrap_text = true;
        @ConfigEntry.Category(value="config")
        @ConfigEntry.Gui.Tooltip
        public int length = -1;
        @ConfigEntry.Category(value="config")
        @ConfigEntry.Gui.Tooltip
        @ConfigEntry.BoundedDiscrete(min=10L, max=100L)
        public int length_cap = 50;
    }

    public static class EnchantmentConfig {
        @ConfigEntry.Category(value="config")
        @ConfigEntry.Gui.Tooltip
        public boolean enchantment_descriptions = true;
        @ConfigEntry.Category(value="config")
        @ConfigEntry.Gui.Tooltip
        public boolean enchanting_table_descriptions = true;
        @ConfigEntry.Category(value="config")
        @ConfigEntry.Gui.Tooltip
        public boolean auto_disable = true;
        @ConfigEntry.Category(value="config")
        @ConfigEntry.Gui.Tooltip
        public boolean require_key_hold = true;
        @ConfigEntry.Category(value="config")
        @ConfigEntry.Gui.Tooltip
        public boolean key_hold_notice = false;
        @ConfigEntry.Category(value="config")
        @ConfigEntry.Gui.Tooltip
        @ConfigEntry.ColorPicker
        public int color = 0x555555;
        @ConfigEntry.Category(value="config")
        @ConfigEntry.Gui.Tooltip
        public String prefix = " ";
        @ConfigEntry.Category(value="config")
        @ConfigEntry.Gui.Tooltip
        public boolean prefix_wrapping = true;
        @ConfigEntry.Category(value="config")
        @ConfigEntry.Gui.Tooltip
        @ConfigEntry.ColorPicker
        public int prefix_color = 0xC6C6C6;
    }
}

