/*
 * Decompiled with CFR 0.152.
 */
package net.legacy.item_tooltips.util;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.legacy.item_tooltips.config.ITConfig;
import net.legacy.item_tooltips.mixin.client.ClientTextTooltipMixin;
import net.legacy.item_tooltips.util.TextUtil;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_327;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_5683;
import net.minecraft.class_5684;

public class TooltipWrapper {
    public static List<class_5481> wrapTooltipLines(int screenWidth, int screenHeight, class_327 textRenderer, List<? extends class_2561> lines) {
        int allowedMaxWidth;
        if (lines.stream().allMatch(text -> text.getString().isBlank())) {
            return List.of();
        }
        int maxWidth = TooltipWrapper.getMaxWidth(textRenderer, lines);
        int length = ITConfig.get.tooltips.length;
        int lengthCap = ITConfig.get.tooltips.length_cap;
        if (lengthCap > 100) {
            lengthCap = 100;
        }
        if (lengthCap < 10) {
            lengthCap = 10;
        }
        if (maxWidth <= (allowedMaxWidth = length > screenWidth / 100 * lengthCap || length == -1 ? screenWidth / 100 * lengthCap : length)) {
            return lines.stream().map(class_2561::method_30937).collect(Collectors.toList());
        }
        String descriptionPrefix = ITConfig.get.descriptions.prefix;
        String enchantmentPrefix = ITConfig.get.enchantments.prefix;
        if (!ITConfig.get.descriptions.prefix_wrapping) {
            descriptionPrefix = "";
        }
        if (!ITConfig.get.enchantments.prefix_wrapping) {
            enchantmentPrefix = "";
        }
        int descriptionPrefixWidth = textRenderer.method_1727(descriptionPrefix);
        int enchantmentPrefixWidth = textRenderer.method_1727(enchantmentPrefix);
        int prefixWidth = Math.max(descriptionPrefixWidth, enchantmentPrefixWidth);
        int adjustedMaxWidth = Math.max(allowedMaxWidth - prefixWidth, 0);
        ArrayList<class_5481> wrapped = new ArrayList<class_5481>();
        for (class_2561 class_25612 : lines) {
            boolean hasDescriptionPrefix = !descriptionPrefix.isEmpty() && class_25612.getString().startsWith(descriptionPrefix);
            boolean hasEnchantmentPrefix = !enchantmentPrefix.isEmpty() && class_25612.getString().startsWith(enchantmentPrefix);
            int splitWidth = hasDescriptionPrefix || hasEnchantmentPrefix ? adjustedMaxWidth : allowedMaxWidth;
            List splitLines = textRenderer.method_1728((class_5348)class_25612, splitWidth);
            for (int i = 0; i < splitLines.size(); ++i) {
                class_5481 prefixedLine;
                class_5481 splitLine = (class_5481)splitLines.get(i);
                if (i == 0) {
                    wrapped.add(splitLine);
                    continue;
                }
                if (hasDescriptionPrefix) {
                    prefixedLine = class_5481.method_30742((class_5481)class_5481.method_30747((String)descriptionPrefix, (class_2583)class_25612.method_10866().method_36139(ITConfig.get.descriptions.prefix_color)), (class_5481)splitLine);
                    wrapped.add(prefixedLine);
                    continue;
                }
                if (hasEnchantmentPrefix) {
                    prefixedLine = class_5481.method_30742((class_5481)class_5481.method_30747((String)enchantmentPrefix, (class_2583)class_25612.method_10866().method_36139(ITConfig.get.enchantments.prefix_color)), (class_5481)splitLine);
                    wrapped.add(prefixedLine);
                    continue;
                }
                wrapped.add(splitLine);
            }
        }
        return wrapped;
    }

    public static List<class_5684> wrapComponents(List<class_5684> components, class_327 font, int screenWidth, int screenHeight) {
        ArrayList<class_5684> wrapped = new ArrayList<class_5684>();
        ArrayList<class_2561> groupedText = new ArrayList<class_2561>();
        for (class_5684 component : components) {
            if (component instanceof class_5683) {
                class_5683 textTooltip = (class_5683)component;
                class_5481 charSequence = ((ClientTextTooltipMixin)textTooltip).getText();
                class_5250 text = TextUtil.toText(charSequence);
                groupedText.add((class_2561)text);
                continue;
            }
            if (!groupedText.isEmpty()) {
                wrapped.addAll(TooltipWrapper.convertComponentToTooltip(groupedText, font, screenWidth, screenHeight));
                groupedText.clear();
            }
            wrapped.add(component);
        }
        if (!groupedText.isEmpty()) {
            wrapped.addAll(TooltipWrapper.convertComponentToTooltip(groupedText, font, screenWidth, screenHeight));
            groupedText.clear();
        }
        return wrapped;
    }

    private static List<class_5683> convertComponentToTooltip(List<class_2561> lines, class_327 font, int screenWidth, int screenHeight) {
        return TooltipWrapper.wrapTooltipLines(screenWidth, screenHeight, font, lines).stream().map(class_5683::new).toList();
    }

    private static int getMaxWidth(class_327 textRenderer, List<? extends class_2561> lines) {
        int maxWidth = 0;
        for (class_2561 class_25612 : lines) {
            int width = textRenderer.method_27525((class_5348)class_25612);
            if (width <= maxWidth) continue;
            maxWidth = width;
        }
        return maxWidth;
    }
}

